/*
   This version of the client
     1) sends the server a positive number indicating
        the length of a sequence of integer values,
     1) sends the server a sequence of ints with the specified length,
     3) receives back from the server the sum of the sequence,
     4) returns to step 1 OR closes the connection to the server.

   Note: This client will send requests to the server until it reaches
         the end-of-file condition on its standard input stream.
*/

import java.net.*;
import java.io.*;
import java.util.Scanner;

public class AdditionClient_v2
{
   public static final int SERVER_PORT = 5000; // Should be above 1023.

   public static void main (String[] args)
   {
      Socket          socket = null;
      BufferedReader  in = null;
      PrintWriter     out = null;

      final String hostName;
      if (args.length > 0)
      {
         hostName = args[0];
      }
      else
      {
         hostName = "localhost";
      }

      final int portNumber;
      if (args.length > 1)
      {
         portNumber = Integer.parseInt(args[1]);
      }
      else
      {
         portNumber = SERVER_PORT;
      }

      // Get this client's process id number (PID). This helps
      // to identify the client in TaskManager or TCPView.
      final ProcessHandle handle = ProcessHandle.current();
      final long pid = handle.pid();
      System.out.println("CLIENT: Process ID number (PID): " + pid );

      // Get the name and IP address of the local host and
      // print them on the console for information purposes.
      try
      {
         final InetAddress address = InetAddress.getLocalHost();
         System.out.println("CLIENT: Hostname: " + address.getCanonicalHostName() );
         System.out.println("CLIENT: IP address: " +address.getHostAddress() );
      }
      catch (UnknownHostException e)
      {
         System.out.println("Unable to determine this client's address.");
         System.out.println( e );
      }

      // Make a connection to the server.
      try
      {
         System.out.println("CLIENT: Connecting to server: " + hostName
                          + " on port " + portNumber );
         // Steps 4, 5, 6.
         socket = new Socket(InetAddress.getByName(hostName),
                             portNumber);

         in = new BufferedReader(
                  new InputStreamReader(          // Step 8.
                       socket.getInputStream())); // Step 7.

         out = new PrintWriter(                   // Step 8.
                      socket.getOutputStream());  // Step 7.
      }
      catch (IOException e)
      {
         System.out.println("CLIENT: Cannot connect to server.");
         e.printStackTrace();
         System.exit(-1);
      }
      System.out.println("CLIENT: Connected to server.");
      // Get this client's local port number and log it to the console.
      // This helps to identify this client in the server's transcript.
      final int port = socket.getLocalPort();
      System.out.println("CLIENT: Local Port: " + port);


      // Step 8 - The application level protocol.
      // Send the server multiple requests.
      final Scanner stdin = new Scanner(System.in);
      while ( stdin.hasNextInt() )
      {
         // Send the server one request.
         final int length = stdin.nextInt(); // Should be a non-negative integer.
         out.println(length);                // Send the sequence length to the server.
         for (int i = 0; i < length; ++i)    // Should have length integers to read.
         {
            final int n = stdin.nextInt();
            out.println(n); // Send each int as a text string on its own line.
         }
         out.flush(); // Make sure all the ints are sent.

         System.out.println("CLIENT: Request sent to the server.");

         // Receive the server's response.
         try
         {
            final String response = in.readLine();
            final int sum = Integer.parseInt(response.trim());
            System.out.println("CLIENT: Server response is: sum = " + sum);
         }
         catch(IOException e)
         {
            System.out.println("CLIENT: Cannot receive response from server.");
            System.out.println( e );
         }
      }

      // Disconnect from the server.
      try
      {
         socket.close();
         System.out.println("CLIENT: Closed socket.");
      }
      catch (IOException e)
      {
         System.out.println("CLIENT: Cannot disconnect from server.");
         System.out.println( e );
      }
   }
}
