/*
   Try examples like
   > java IP_Addresses  www.google.com
   > java IP_Addresses  google.com
   > java IP_Addresses  pnw.edu
   > java IP_Addresses  swapi.dev
   > java IP_Addresses  localhost
*/

import java.net.*;

public class IP_Addresses
{
   public static void main(String[] args)
   {
      // Get the name and IP address of the local host.
      try
      {
         final InetAddress address = InetAddress.getLocalHost();
         System.out.println("Local Host:");
         System.out.println( "\t" + address.getHostName() );
         System.out.println( "\t" + address.getCanonicalHostName() );
         System.out.println( "\t" + address.getHostAddress() );
      }
      catch (UnknownHostException e)
      {
         System.out.println("Unable to determine this host's address");
      }

      for (final String hostName : args)
      {
         try
         {
            // Get name and address of the host given on command-line.
            final InetAddress address = InetAddress.getByName(hostName);
            System.out.println(hostName + ":");
            // Print the retrieved name and address.
            System.out.println( "\t" + address.getHostName() );
            System.out.println( "\t" + address.getCanonicalHostName() );
            System.out.println( "\t" + address.getHostAddress() );

            // Get name and all addresses of the host given on command-line.
            final InetAddress[] addressList = InetAddress.getAllByName(hostName);
            System.out.println(hostName + ":");
            // Print the retrieved name.
            System.out.println( "\t" + addressList[0].getHostName() );
            // Print all the retrieved addresses.
            for (int j = 0; j < addressList.length; ++j)
            {
               System.out.println( "\t" + addressList[j].getHostAddress() );
            }
         }
         catch (UnknownHostException e)
         {
            System.out.println("Unable to find address for " + hostName);
         }
      }
   }
}
