/*
   Try examples like
      > java Retrieve_URL_HTTP_Connection  cs.pnw.edu/~rlkraft/
      > java Retrieve_URL_HTTP_Connection  www.google.com
      > java Retrieve_URL_HTTP_Connection  en.wikipedia.org/wiki/Computer_science
      > java Retrieve_URL_HTTP_Connection  swapi.dev/api/people/3/?format=json
*/

import java.net.*;
import java.io.*;

public class Retrieve_URL_HTTP_Connection
{
   public static void main(String[] args) throws IOException
   {
      final String urlString;
      if (args.length > 0)
      {
         urlString = "http://" + args[0]; // always use HTTP (try https)
      }
      else
      {
         urlString = null;
         System.err.println("Usage: java Retrieve_URL_HTTP_Connection <url>");
         System.exit(1);
      }

      try
      {
         final URL url = new URL(urlString);
         final URLConnection connection = url.openConnection();

         // Cast the URLConnection to a HttpURLConnection.
         final HttpURLConnection httpConnection = (HttpURLConnection)connection;

         // Check if response code is HTTP_OK (200)
         final int code = httpConnection.getResponseCode();
         final String message = httpConnection.getResponseMessage();
         System.out.println(code + " " + message);
         if (code != HttpURLConnection.HTTP_OK)
         {
            return;
         }

         final BufferedReader bf = new BufferedReader(
                                       new InputStreamReader(
                                          connection.getInputStream(), "latin1"));

         // Read the server's response.
         for (String oneLine; (oneLine = bf.readLine()) != null; )
         {
            System.out.println(oneLine);
         }
      }
      catch (MalformedURLException e)
      {
         System.out.println(e);
      }
      catch (IOException e)
      {
         System.out.println(e);
      }
   }
}

