/**
   This program counts the total number of characters from each
   line of its standard input and writes the resulting int to
   its standard output.

   This program does not count the CR and LF characters in the
   input stream.

   When using Windows, if standard input is the console
   keyboard, use ^z (Control-z) to denote the end of file
   (and you must use ^z at the beginning of a line!).
*/
import java.util.Scanner;

public class CountCharacters
{
   public static void main(String[] args)
   {
      int characterCount = 0;

      // Create a Scanner object to make it easier to use System.in
      final Scanner scanner = new Scanner( System.in );

      while ( scanner.hasNextLine() )
      {
         final String oneLine = scanner.nextLine();
         characterCount += oneLine.length();
      }
      System.out.println( characterCount );
   }
}
