/**
   This program reads lines from standard input and
   echos them to standard output and standard error.

   This program can be used to test the output redirection
   operators for the standard error stream, `2>`, `2>&1`,
   `&>`, and `|&`.

   When using Windows, if standard input is the console
   keyboard, use ^z (Control-z) to denote the end of file
   (and you must use ^z at the beginning of a line!).
*/
import java.util.Scanner;

public class Echo2
{
   public static void main(String[] args)
   {
      // Create a Scanner object to make it easier to use System.in
      final Scanner scanner = new Scanner( System.in );

      while ( scanner.hasNextLine() )
      {
         final String oneLine = scanner.nextLine();
         System.out.println( oneLine );
         System.err.println( oneLine.toUpperCase() );
      }
   }
}
