/**
   This program prints each token in its standard input
   om its own line.

   A token is a sequence of characters that does not contain
   the space character.

   When using Windows, if standard input is the console
   keyboard, use ^z (Control-z) to denote the end of file
   (and you must use ^z at the beginning of a line!).
*/
import java.util.Scanner;

public class OneWordPerLine
{
   public static void main(String[] args)
   {
      // Create a Scanner object to make it easier to use System.in
      final Scanner scanner = new Scanner( System.in );

      while ( scanner.hasNextLine() )
      {
         final String oneLine = scanner.nextLine();
         // Create a Scanner that breaks the input line into tokens.
         final Scanner scanner2 = new Scanner( oneLine );
         while ( scanner2.hasNext() ) // While there is another token.
         {
            final String word = scanner2.next(); // Consume the token.
            System.out.println( word );          // Print the token.
         }
      }
   }
}
