/**
   This very simple program writes one line of text to its
   standard output stream and one line of text to its
   standard error stream.

   This program can be used as the source program in a pipeline
   to test how the pipeline operator handles the two output
   streams from the source of the pipeline.

   For example, compare these command-lines.
      > java Source | java Double
      > java Source 2>&1 | java Double
      $ java Source |& java Double

   This program can also be used to test the output redirection
   operators `>` and `2>` and `&>` and `2>&1`.

   Compare these command-lines.
      > java Source  > temp.txt
      > java Source 2> temp.txt
      > java Source  > temp.txt 2>&1
      $ java Source &> temp.txt
*/
import java.util.Scanner;

public class Source
{
   public static void main(String[] args)
   {
      System.out.println("this-string-of-text-was-sent-to-the-standard-OUTPUT-stream");
      System.err.println("this=string=of=text=was=sent=to=the=standard=ERROR=stream");
   }
}
