
Java Streams
============

Like all programming languages, Java has a way for programs to make use
of the data streams provided by the operating system. Java's streams are
defined in the `java.io` package.

* <https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/package-summary.html>

Here are references to several online book chapters that review using Java
streams, mostly for file I/O.

<ul>
<li><a href="https://runestone.academy/ns/books/published/javajavajava/chapter-files.html">Chapter 11: Files and Streams</a> (<a href="http://www.cs.trincoll.edu/~ram/jjj/jjj-os-20170625.pdf#page=515">PDF</a>) from <a href="https://runestone.academy/ns/books/published/javajavajava/">Java Java Java</a></li>
<li><a href="https://ptgmedia.pearsoncmg.com/images/9780135166314/samplepages/9780135166314_Sample.pdf#page=23">Chapter 2, Input and Output</a> from <a href="https://www.informit.com/store/core-java-volume-ii-advanced-features-9780135166314">Core Java, Volume II--Advanced Features, 11th Edition</a></li>
<li><a href="https://math.hws.edu/javanotes-swing/c11/s1.html">Section 11.1, I/O Streams</a> (<a href="https://math.hws.edu/eck/cs124/downloads/javanotes9-swing-linked.pdf#page=582">PDF</a>) (<a href="https://math.hws.edu/javanotes-swing/source/chapter11/">Source code</a>)</li>
<li><a href="https://link.springer.com/content/pdf/10.1007/978-1-4842-3348-1_7">Chapter 7, Input/Output</a> from <a href="https://link.springer.com/book/10.1007/978-1-4842-3348-1">Java Language Features</a></li>
<li><a href="https://people.scs.carleton.ca/~lanthier/teaching/COMP1406/Notes/COMP1406_Ch11_FileIO.pdf">Chapter 11, Saving and Loading Information</a> (<a href="https://people.scs.carleton.ca/~lanthier/teaching/COMP1406/Notes/Code/Chapter11/">code</a>)from <a href="https://people.scs.carleton.ca/%7Elanthier/teaching/COMP1406/notes.html">Carleton University</a></li>
<li><a href="https://people.scs.carleton.ca/~lanthier/teaching/COMP2401/Notes/COMP2401_Ch6_StreamsAndFileIO.pdf">Chapter 6, Streams and File/Device I/O</a> (<a href="https://people.scs.carleton.ca/~lanthier/teaching/COMP2401/Notes/Code/ch6/">code</a>) from <a href="https://people.scs.carleton.ca/%7Elanthier/teaching/COMP2401/notes.html">Carleton University</a></li>
<li><a href="https://docs.oracle.com/javase/tutorial/essential/io/streams.html">I/O Streams</a> from the <a href="https://docs.oracle.com/javase/tutorial/essential/index.html">Java Tutorials</a></li>
</ul>


**NOTE:** The Java language now has two very different kinds of object that
are called "streams". There are the traditional I/O streams that we introduce
in this document. In addition, starting in Java 8, Java defined a `Stream`
class that is an implementation of the Stream abstract data type, an idea that
comes from functional programming languages. The new `Stream` class is not for
doing I/O. The new `Stream` class provides a modern way to process data
structures from the Java Collections Framework.

* <https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/util/stream/package-summary.html>
* <https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/package-summary.html>

Here are the basic "stream" classes in Java. You can see that the
`java.util.stream.Stream` class is nothing like the `java.io.InputStream`
or `java.io.OutputStream` classes.

* <https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/InputStream.html>
* <https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/io/OutputStream.html>
* <https://docs.oracle.com/en/java/javase/21/docs/api/java.base/java/util/stream/Stream.html>

The Stream abstract data type is becoming an important part of modern
programming languages. It plays a big part in modern Java.

* <https://en.wikipedia.org/wiki/Stream_(abstract_data_type)>
* <https://dev.java/learn/api/streams/>
* <https://www.baeldung.com/java-8-streams>
* <https://link.springer.com/content/pdf/10.1007/978-1-4842-7080-6_8>
* <https://link.springer.com/content/pdf/10.1007/978-1-4842-7135-3_6>


