/*
 * Renderer 3. The MIT License.
 * Copyright (c) 2022 rlkraft@pnw.edu
 * See LICENSE for details.
*/

import renderer.scene.*;
import renderer.scene.primitives.*;
import renderer.framebuffer.FrameBuffer;
import renderer.pipeline.*;

import java.awt.Color;

/**
   Compile and run this program. Look at its output, both
   in the console window and in the PPM file that it creates.
<p>
   The output in the console window shows you the debugging
   information from the renderer. It shows the results from
   each stage of the rendering pipeline. This program draws
   six lines that fan out from the .
*/
public class ShowClippingExample_R3
{
   public static void main(String[] args)
   {
      final Scene scene = new Scene("ShowClippingExample_R3");
      final Model model = new Model("clipping-example");
      scene.addPosition(new Position(model,
                                     "p0",
                                     new Vector(0, 0, -1)));

      model.addVertex(new Vertex(0,  0.0, 0),
                      new Vertex(2, -1.0, 0),
                      new Vertex(2, -0.6, 0),
                      new Vertex(2, -0.3, 0),
                      new Vertex(2,  0.3, 0),
                      new Vertex(2,  0.6, 0),
                      new Vertex(2,  1.0, 0));

      model.addColor(Color.red,
                     Color.green,
                     Color.blue);

      model.addPrimitive(new LineSegment(0, 1, 0, 1),
                         new LineSegment(0, 2, 0, 2),
                         new LineSegment(0, 3, 0, 3),
                         new LineSegment(0, 4, 0, 3),
                         new LineSegment(0, 5, 0, 2),
                         new LineSegment(0, 6, 0, 1));

      final int width  = 300;
      final int height = 300;
      final FrameBuffer fb = new FrameBuffer(width, height, Color.white);

      Rasterize.doAntiAliasing = false;
      Rasterize.doGamma = true;

      scene.debug = true;
      Clip.debug = true;
      Rasterize.debug = false;

      Pipeline.render(scene, fb);
      fb.dumpFB2File("ShowClippingExample_R3.ppm");
      System.err.println("Saved " + "ShowClippingExample_R3.ppm");
   }
}
