/*
 * Renderer 3. The MIT License.
 * Copyright (c) 2022 rlkraft@pnw.edu
 * See LICENSE for details.
*/

import renderer.scene.*;
import renderer.scene.primitives.*;
import renderer.framebuffer.*;
import renderer.pipeline.*;

import java.awt.Color;

/**
   This program shows that the clipping problem from the first renderer
   has been fixed by the clipping stage in this renderer.
*/
public class SomethingWrong_1_fixed
{
   public static void main(String[] args)
   {
      final Scene scene = new Scene("SomethingWrong_1_fixed");
      final Model model = new Model("something-wrong-1");
      scene.addPosition(new Position(model, "p0"));

      model.addVertex(new Vertex(0.00000002, 0.00000002, -0.00000001),
                      new Vertex(1.0,        1.0,        -0.00000001));

      model.addColor(Color.red);

      model.addPrimitive(new LineSegment(0, 1, 0));

      final int width  = 100;
      final int height = 100;
      final FrameBuffer fb = new FrameBuffer(width, height, Color.white);

      scene.debug = true;
      Rasterize.debug = true;
      Clip.debug = true;
      Pipeline.render(scene, fb);
      fb.dumpFB2File("SomethingWrong_1_fixed.ppm");
      System.out.println("Saved " + "SomethingWrong_1_fixed.ppm");
   }
}
