
/**
   Implement this dataflow graph.

       task1         task2
            \       /     \
             \     /       \
              task3         task4
                   \       /
                    \     /
                     task5
*/
public class DataFlow_v2
{
   public static void main(String[] args) throws InterruptedException
   {
      final Task<Integer,Integer> task1 = new Task<>(1, 1, 1);
      final Task<Integer,Integer> task2 = new Task<>(2, 2, 3);
      final Task<Integer,Integer> task3 = new Task<>(3, 3, 2);
      final Task<Integer,Integer> task4 = new Task<>(4, 4, 4);
      final Task<Integer,Integer> task5 = new Task<>(5, 5, 3);

      final Thread t1 = new Thread(task1);
      final Thread t2 = new Thread(task2);
      final Thread t3 = new Thread(task3);
      final Thread t4 = new Thread(task4);
      final Thread t5 = new Thread(task5);

      t1.start();
      t2.start();
      t2.join();  // Should join on task2 first! (Why?)
      t4.start();
      t1.join();
      t3.start();
      t3.join();
      t4.join();
      t5.start();
   }
}

/* What is wrong with the following code?
      t1.start();
      t2.start();
      t1.join();
      t2.join();
      t3.start();
      t4.start();  // task4 waits on task1
      t3.join();
      t4.join();
      t5.start();
*/
