
/**
   Implement this dataflow graph.

       task1         task2         task3
            \       /     \       /
             \     /       \     /
              task4         task5
                   \       /
                    \     /
                     task6

   The following implementation of this dataflow graph uses eight threads.
   But we should be able to implement the graph in just three threads. (Why?).
*/
public class DataFlow_v3a
{
   public static void main(String[] args) throws InterruptedException
   {
      final Task<Integer,Integer> task1 = new Task<>(1, 1, 1);
      final Task<Integer,Integer> task2 = new Task<>(2, 2, 3);
      final Task<Integer,Integer> task3 = new Task<>(3, 3, 5);
      final Task<Integer,Integer> task4 = new Task<>(4, 4, 2);
      final Task<Integer,Integer> task5 = new Task<>(5, 5, 4);
      final Task<Integer,Integer> task6 = new Task<>(6, 6, 3);

      final Thread t1 = new Thread(task1);
      final Thread t2 = new Thread(task2);
      final Thread t3 = new Thread(task3);
      final Thread t4 = new Thread(task4);
      final Thread t5 = new Thread(task5);
      final Thread t6 = new Thread(task6);

      t1.start();
      t2.start();
      t3.start();
      t2.join();  // Must join on task2 first! (Why?)

      // t1.join();
      // t4.start();
      final Thread t7 = new Thread(){
                  public void run(){try{ t1.join(); // Override run() method from Thread class.
                                         t4.start();
                                       }catch(InterruptedException e){}}
                                    };
      t7.start();

      // t3.join();
      // t5.start();
      final Thread t8 = new Thread(){
                  public void run(){try{ t3.join(); // Override run() method from Thread class.
                                         t5.start();
                                       }catch(InterruptedException e){}}
                                    };
      t8.start();

      t7.join(); // So we know that t4 is started.
      t8.join(); // So we know that t5 is started.
      t4.join();
      t5.join();
      t6.start();
   }
}

/* What is wrong with the following code?
      t1.start();
      t2.start();
      t3.start();
      t2.join();
      t1.join();
      t4.start();
      t3.join();
      t5.start();
      t4.join();
      t5.join();
      t6.start();
*/