
/**
   Implement this dataflow graph.

       task1         task2         task3
            \       /     \       /
             \     /       \     /
              task4         task5
                   \       /
                    \     /
                     task6

   The following implementation of this dataflow graph uses three threads.
   The first thread does task1, task4, and task6.
   The second thread does task2.
   The third thread does task3 and task5.
*/
public class DataFlow_v3b
{
   public static void main(String[] args)
   {
      final Task<Integer,Integer> task1 = new Task<>(1, 1, 1);
      final Task<Integer,Integer> task2 = new Task<>(2, 2, 3);
      final Task<Integer,Integer> task3 = new Task<>(3, 3, 5);
      final Task<Integer,Integer> task4 = new Task<>(4, 4, 2);
      final Task<Integer,Integer> task5 = new Task<>(5, 5, 4);
      final Task<Integer,Integer> task6 = new Task<>(6, 6, 3);

      final Thread t2 = new Thread(task2);  // Schedule a task on this thread.
      t2.start();

      final Thread t3 = new Thread(
                               ()->{try{ task3.run();  // Schedule a task on this thread.
                                         t2.join();
                                         task5.run();  // Schedule a task on this thread.
                                       }catch(InterruptedException e){}}
                                  );
      t3.start();

      final Thread t1 = new Thread(
                               ()->{try{ task1.run();  // Schedule a task on this thread.
                                         t2.join();
                                         task4.run();  // Schedule a task on this thread.
                                         t3.join();
                                         task6.run();  // Schedule a task on this thread.
                                       }catch(InterruptedException e){}}
                                  );
      t1.start();
   }
}

/*
   What is wrong (and what is right) with scheduling task1, task2,
   task3 on thread 1, task4, task5 on thread 2, and task6 on thread 3?
*/
