
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

/**
   Implement this dataflow graph.

       task1         task2         task3
            \       /     \       /
             \     /       \     /
              task4         task5
                   \       /
                    \     /
                     task6

   The following implementation of this dataflow graph uses three threads.
   The first thread does task1 and task4.
   The second thread does task2 and task6.
   The third thread does task3 and task5.
   This implementation requires that a "signal" be sent from
   the second thread to each of the first and third threads.
*/
public class DataFlow_v3c
{
   public static void main(String[] args)
   {
      final Task<Integer,Integer> task1 = new Task<>(1, 1, 1);
      final Task<Integer,Integer> task2 = new Task<>(2, 2, 3);
      final Task<Integer,Integer> task3 = new Task<>(3, 3, 5);
      final Task<Integer,Integer> task4 = new Task<>(4, 4, 2);
      final Task<Integer,Integer> task5 = new Task<>(5, 5, 4);
      final Task<Integer,Integer> task6 = new Task<>(6, 6, 3);

      final CompletableFuture<Integer> future1 = new CompletableFuture<>(); // empty future
      final CompletableFuture<Integer> future3 = new CompletableFuture<>(); // empty future

      final Thread t1 = new Thread(
                               ()->{try{ task1.run();   // Schedule a task on this thread.
                                         future1.get(); // Get task2's result (block).
                                         task4.run();   // Schedule a task on this thread.
                                       }catch(InterruptedException
                                             |ExecutionException e){}}
                                  );
      t1.start();

      final Thread t3 = new Thread(
                               ()->{try{ task3.run();   // Schedule a task on this thread.
                                         future3.get(); // Get task2's result (block).
                                         task5.run();   // Schedule a task on this thread.
                                       }catch(InterruptedException
                                             |ExecutionException e){}}
                                  );
      t3.start();

      final Thread t2 = new Thread(
                               ()->{try{ task2.run();         // Schedule a task on this thread.
                                         future1.complete(0); // Send taks2's result to task4.
                                         future3.complete(0); // Send taks2's result to task5.
                                         t1.join();
                                         t3.join();
                                         task6.run();         // Schedule a task on this thread.
                                       }catch(InterruptedException e){}}
                                  );
      t2.start();
   }
}
