
/**
   Implement this dataflow graph.

          task1            task2
            |             /
            |            /
          task3         /
         /     \       /
        /       \     /
   task4         task5
        \       /
         \     /
          task6

   We can implement this dataflow graph with
   three threads using only "fork-join".
   The first thread does task1 and task3.
   The second thread does task2 and task5.
   The third thread does task4 and task6.
*/
public class DataFlow_v4a
{
   public static void main(String[] args)
   {
      final Task<Integer,Integer> task1 = new Task<>(1, 1, 2);
      final Task<Integer,Integer> task2 = new Task<>(2, 2, 4);
      final Task<Integer,Integer> task3 = new Task<>(3, 3, 2);
      final Task<Integer,Integer> task4 = new Task<>(4, 4, 1);
      final Task<Integer,Integer> task5 = new Task<>(5, 5, 3);
      final Task<Integer,Integer> task6 = new Task<>(6, 6, 2);

      final Thread t1 = new Thread(
                               ()-> { task1.run();
                                      task3.run(); }
                                  );
      t1.start();

      final Thread t2 = new Thread(
                               ()->{try{ task2.run();
                                         t1.join();
                                         task5.run();
                                       }catch(InterruptedException e){}}
                                  );
      t2.start();

      final Thread t3 = new Thread(
                               ()->{try{ t1.join();
                                         task4.run();
                                         t2.join();
                                         task6.run();
                                       }catch(InterruptedException e){}}
                                  );
      t3.start();
   }
}
