
import java.util.concurrent.Semaphore;

/**
   Redraw this dataflow graph,

          task1            task2
            |             /
            |            /
          task3         /
         /     \       /
        /       \     /
   task4         task5
        \       /
         \     /
          task6

   this way

    task1
       |
       |
    task3    task2
       | \    /
       |  \  /
    task4  task5
       |  /
       | /
    task6

   We should be able to implement this dataflow graph with just two threads.
   The first thread should do task1, task3, task4, and task6.
   The second thread should do task2 and task5.
   But, we need the first thread to send a "signal" to the second thread
   to let it know when it can start task5.

   In this version we use a semaphore to send a "signal".
*/
public class DataFlow_v4c
{
   public static void main(String[] args)
   {
      final Task<Integer,Integer> task1 = new Task<>(1, 1, 2);
      final Task<Integer,Integer> task2 = new Task<>(2, 2, 4);
      final Task<Integer,Integer> task3 = new Task<>(3, 3, 2);
      final Task<Integer,Integer> task4 = new Task<>(4, 4, 1);
      final Task<Integer,Integer> task5 = new Task<>(5, 5, 3);
      final Task<Integer,Integer> task6 = new Task<>(6, 6, 2);

      final Semaphore sem = new Semaphore(0); // non-signaled semaphore

      final Thread t2 = new Thread(
                               ()->{try{ task2.run();
                                         sem.acquire();
                                         task5.run();
                                       }catch(InterruptedException e){}}
                                  );
      t2.start();

      final Thread t1 = new Thread(
                               ()->{try{ task1.run();
                                         task3.run();
                                         sem.release();
                                         task4.run();
                                         t2.join();
                                         task6.run();
                                       }catch(InterruptedException e){}}
                                  );
      t1.start();
   }
}
