
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

/**
   Implement this dataflow graph using "message passing"
   synchronization. In this implementation, we will use
   futures as "messages".

          task1            task2
            |             /
           1|            /
          task3         /
         /     \       /
       3/       \4    /2
   task4         task5
        \       /
        5\     /6
          task6

   Message passing makes code easy to write and read, but
   it doesn't try to optimize the number of threads.

   Notice that the order in which we start the threads does
   not matter and we do not need any join() methods. We need
   one Thread for each task and one Future for every message
   that needs to be sent (each edge in the dataflow graph
   represents one message).
*/
public class DataFlow_v4e
{
   public static void main(String[] args)
   {
      final var task1 = new Task<Integer,Integer>(1, 1, 2);
      final var task2 = new Task<Integer,Integer>(2, 2, 4);
      final var task3 = new Task<Integer,Integer>(3, 3, 2);
      final var task4 = new Task<Integer,Integer>(4, 4, 1);
      final var task5 = new Task<Integer,Integer>(5, 5, 3);
      final var task6 = new Task<Integer,Integer>(6, 6, 2);

      final var future1 = new CompletableFuture<Integer>();
      final var future2 = new CompletableFuture<Integer>();
      final var future3 = new CompletableFuture<Integer>();
      final var future4 = new CompletableFuture<Integer>();
      final var future5 = new CompletableFuture<Integer>();
      final var future6 = new CompletableFuture<Integer>();

      final Thread t1 = new Thread(
                               ()->{ task1.run();
                                     future1.complete(0); // send a message
                                   }
                                  );

      final Thread t2 = new Thread(
                               ()->{ task2.run();
                                     future2.complete(0); // send a message
                                   }
                                  );


      final Thread t3 = new Thread(
                               ()->{try{ future1.get(); // receive a message (blocks)
                                         task3.run();   // run a task on this thread
                                         future3.complete(0); // send a message
                                         future4.complete(0); // send a message
                                       }catch(ExecutionException
                                             |InterruptedException e){}}
                                  );

      final Thread t4 = new Thread(
                               ()->{try{ future3.get(); // receive a message (blocks)
                                         task4.run();   // run a task on this thread
                                         future5.complete(0); // send a message
                                       }catch(ExecutionException
                                             |InterruptedException e){}}
                                  );

      final Thread t5 = new Thread(
                               ()->{try{ future2.get(); // receive a message (blocks)
                                         future4.get(); // receive a message (blocks)
                                         task5.run();   // run a task on this thread
                                         future6.complete(0); // send a message
                                       }catch(ExecutionException
                                             |InterruptedException e){}}
                                  );

      final Thread t6 = new Thread(
                               ()->{try{ future5.get(); // receive a message (blocks)
                                         future6.get(); // receive a message (blocks)
                                         task6.run();   // run a task on this thread
                                       }catch(ExecutionException
                                             |InterruptedException e){}}
                                  );
      t1.start();
      t2.start();
      t3.start();
      t4.start();
      t5.start();
      t6.start();
   }
}
