
import java.util.Random;
import java.util.concurrent.TimeUnit;

/**
   This class represents a generic task for
   our dataflow problems.
*/
class Task<U, V> implements Runnable
{
   private final U dataIn;
   private final V dataOut;
   private final int colunmNumber;
   private final Random random;

   Task(U dataIn, V dataOut, int columnNumber)
   {
      this.dataIn = dataIn;
      this.dataOut = dataOut;
      this.colunmNumber = columnNumber;
      this.random = new Random();
   }

   @Override
   public void run()
   {
      // Tab over to the column used by this task.
      final String indent = "\t".repeat(colunmNumber); // Java 11.

      // How long this task should "work".
      int computeTime = 2 + random.nextInt(8); // Between 2 and 10 seconds.

      // Print a message in the appropriate column for this task.
      // The message shows this task's id and the number of seconds
      // left for this task to execute.
      System.out.println(indent + "t" + dataIn + "," + computeTime);
      while (computeTime > 0)
      {
         try{ TimeUnit.SECONDS.sleep(1); }catch(InterruptedException e){}
         --computeTime;
         System.out.println(indent + "t" + dataIn + "," + computeTime);
      }
   }
}
